/**********************************************************************

	--- Qt Architect generated file ---

	File: omixdev.cpp
	Last generated: Sat Jun 6 22:30:55 1998

 *********************************************************************/

#include <stdlib.h>
#include <wintv.h>
#include "omixdev.h"

#ifdef myDEBUG
#define omixDEBUG
#endif

#define Inherited omixdevdata

omixdev::omixdev
(
	QWidget* parent,
	const char* name,
	mixer *_mix,
	int _can_grabber_audio
)
	:
	Inherited( parent, name ), mix(_mix), can_grabber_audio(_can_grabber_audio)
{
#ifdef omixDEBUG
  debug("omix: start init");
#endif
  int devNr;
  char *devName;
  c_idevice->clear();
  devName=mix->getFirstDeviceName(&devNr,true);
  if ( !devName ) 
     c_idevice->insertItem("<empty>");
  else while ( devName ) {
    c_idevice->insertItem((const char *)devName);
    devName=mix->getNextDeviceName(&devNr,true);
  }
  mixerslider->setRange( 0, MIXER_MAX_VALUE );
  rc=NULL;
}

omixdev::~omixdev()
{
  if (rc) free(rc);
}

void omixdev::setData(rcfile *_rc)
{
#ifdef omixDEBUG
  debug("omix: setData");
#endif

  if (rc) free(rc);
  rc= (rcfile *)malloc( sizeof(rcfile) );

  rc->volume_right=_rc->volume_right;
  rc->use_tv_volume=_rc->use_tv_volume;
  rc->use_master_volume=_rc->use_master_volume;
  rc->mixerDevice=_rc->mixerDevice;

  // get all the recording input devices
  int devNr,thisItem=0;
  aktive=-1;
  char *devName;
  devName=mix->getFirstDeviceName(&devNr,true);
  while ( devName ) {
    if (devNr==rc->mixerDevice) aktive=thisItem;
    thisItem++;
    devName=mix->getNextDeviceName(&devNr,true);
  }

  // set the active input device
  if ((aktive != -1)) {
    c_idevice->setCurrentItem(aktive);
  } else {
    mix->getFirstDeviceName(&aktive,true);
    rc->mixerDevice=aktive;
    c_idevice->setCurrentItem(0);
    if ( mix->setDevice(aktive) ) {
      mixerslider->setValue(rc->volume_right);
    }
  }

  mixerslider->setValue(rc->volume_right);

  if ( !can_grabber_audio ) {
    r_volgrabber->setEnabled(false);
    r_volgrabber->setChecked(false);
  } else r_volgrabber->setChecked(rc->use_tv_volume);

  r_mastervol->setChecked(!rc->use_master_volume);

#ifdef omixDEBUG
  debug("omix: setData end");
#endif
}
void omixdev::mixDeviceSLOT(const char *name)
{
  rc->mixerDevice=mix->name2Device(name);
#ifdef omixDEBUG
  debug("omix: new device %d",rc->mixerDevice);
#endif
  if ( rc->mixerDevice == NO_MDEV ) 
    warning("omix: error setting new device %s, %d",name,rc->mixerDevice);
  bool valid= mix->setDevice(rc->mixerDevice);
  mixerslider->setValue(mix->getVolume(VOL_LEFT));
#ifdef omixDEBUG
  debug("omix: new device %s is %s [%s]",name,valid?"valid":"invalid",mix->isStereoDevice()?"stereo":"mono");
#endif
}
void omixdev::volGrabberSLOT(bool on)
{
  rc->use_tv_volume=on;
  mixerslider->setEnabled(!on);
  r_mastervol->setEnabled(!on);
  c_idevice->setEnabled(!on);
}
void omixdev::newVolumeSLOT(int v)
{
  mix->setVolume(v,VOL_BOTH);
}
void omixdev::masterVolSLOT(bool on)
{
  rc->use_master_volume=!on;
#ifdef omixDEBUG
  debug("omix: use master volume: %s",!on?"yes":"no");
#endif
}
void omixdev::sliderAttSLOT(bool on)
{
}
#include "omixdev.moc"











