#ifndef colorspace_h
#define colorspace_h

#ifdef __cplusplus
extern "C" {
#endif

void rgb24_to_lut4(unsigned char *dest, unsigned char *src, int w, int h);
void bgr24_to_lut4(unsigned char *dest, unsigned char *src, int w, int h);
void rgb32_to_lut4(unsigned char *dest, unsigned char *src, int w, int h);
void bgr32_to_lut4(unsigned char *dest, unsigned char *src, int w, int h);
void gray_to_lut4(unsigned char *dest, unsigned char *src, int w, int h);

/* ------------------------------------------------------------------- */
/* RGB conversions                                                     */

void swap_rgb24(char *mem, int n);
void rgb24_to_bgr24(unsigned char *dest, unsigned char *src, int w, int h);
void bgr24_to_bgr32(unsigned char *dest, unsigned char *src, int w, int h);
void bgr24_to_rgb32(unsigned char *dest, unsigned char *src, int w, int h);
void rgb32_to_rgb24(unsigned char *dest, unsigned char *src, int w, int h);

/* ------------------------------------------------------------------- */
/* YUV conversions                                                     */

void packed422_to_planar422(unsigned char *d, unsigned char *s, int w, int h);
void packed422_to_planar411(unsigned char *d, unsigned char *s, int w, int h);

#ifdef __cplusplus
}
#endif

#endif





