/* 
    kvtx

    Copyright (C) 1998,1999 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef pagelist_h
#define pagelist_h

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdir.h>
#include <qstrlist.h>

#ifdef __cplusplus
extern "C" {      
#endif
#include <sys/vtx.h>
#include <fileio.h>
#ifdef __cplusplus
}
#endif

#define FIRSTPAGE 100
#define LASTPAGE 899

struct onepage {
  int subpage;
  vtxpage_t *pagep;
  struct onepage *next, *prev;
};

class pagedir {
public:
  pagedir( const char * _dir = 0, bool _keepInMem = true );
  ~pagedir();

  bool setDir( const char * _dir );
  bool rescan();

  vtxpage_t * setPage( int _page, bool reloadPage = false );

  bool hasSubPages();
  int currentPage() { return thepage; }
  int currentSubPage() { return thesubpage; }

  vtxpage_t * setSubPage( int _spage, bool reloadPage = false );
  vtxpage_t * cycleSubPages( bool reloadPage = false );

  vtxpage_t * nextPage( bool reloadPage = false );
  vtxpage_t * prevPage( bool reloadPage = false );

  vtxpage_t * nextSubPage( bool reloadPage = false );
  vtxpage_t * prevSubPage( bool reloadPage = false );

  void setKeepInMem( bool _kim ) { keepInMem=_kim; }
  bool getKeepInMem() { return keepInMem; }

  vtxpage_t * reload();

private:
  void freeMem();
  vtxpage_t * loadFromFile( const char * name );
  QString pagedir::getPageName( int p, int sp );

  bool keepInMem;

  QString currPageS,currSubPageS;
  int thepage,thesubpage;
  struct onepage ** pagelist;
  struct onepage * opage;

  QString dir;

  QDir cacheDirDir;
  QFileInfo * fi;

  unsigned char buffer[65536];
  int virtualpage;

  int vtx_charset;
};

class cachedir {
public:
  cachedir( const char * _dir = 0 );
  ~cachedir();

  bool setDir( const char * _dir );
  bool rescan();

  //const char * getFirst();
  //const char * getNext();

  QStrList * getList();

private:
  void freeMem();

  QString dir;

  QDir cacheDirDir;
  QFileInfo * fi;

  QStrList * clist;
};
#endif
