/***************************************************************************
                      kstiface_impl.cpp  -  Part of KST
                             -------------------
    begin                : Thu Jun 19 2003
    copyright            : (C) 2003 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kstiface_impl.h"
#include "kstdoc.h"
#include "kst.h"
#include "kstvector.h"
#include "kstscalar.h"
#include "kstplot.h"
#include "kstequationcurve.h"
#include "kstdatacollection.h"
#include <assert.h>


KstIfaceImpl::KstIfaceImpl(KstDoc *doc, KstApp *app)
: DCOPObject("KstIface"), _doc(doc), _app(app) {
  assert(doc);
}


KstIfaceImpl::~KstIfaceImpl() {
}


void KstIfaceImpl::showDataManager() {
  _app->showDataManager();
}


QStringList KstIfaceImpl::scalarList() {
  return KST::scalarList.tagNames();
}


QStringList KstIfaceImpl::vectorList() {
  return KST::vectorList.tagNames();
}


bool KstIfaceImpl::plotEquation(const QString& xvector, const QString& equation, const QString& plotName, const QColor& color) {
  KstVectorPtr v;
  KstPlot *plot = 0;
  KstVectorList::Iterator it = KST::vectorList.findTag(xvector);
  QString etag, ptag;

  if (equation.isEmpty() || it == KST::vectorList.end()) {
    return false;
  }

  v = *it;

  // FIXME: generate etag, ptag properly - work out semantics for finding existing plot
  etag = "Eq-" + plotName;
  ptag = "P-" + plotName;

  if (!plotName.isEmpty()) {
    plot = KST::plotList.FindKstPlot(plotName);
  }

  if (!plot) {
    plot = new KstPlot(ptag);
    KST::plotList.append(plot);
  }

  KstEquationCurvePtr eq;

  eq = new KstEquationCurve(etag, equation, v, true,
                          color.isValid() ? color : QColor("darkBlue"));

  KST::dataObjectList.append(KstDataObjectPtr(eq));

  plot->Curves.append(KstBaseCurvePtr(eq));

  KST::plotList.arrangePlots(KST::plotList.getPlotCols());

  _doc->update();
  _doc->setModified();
  _doc->updateDialogs();

  return true;
}


const QString& KstIfaceImpl::generateVector(double from, double to, int points, const QString& name) {
KstVectorPtr v = KstVector::generateVector(from, to, points, name);
return v->tagName();
}

// vim: ts=2 sw=2 et
