#!/usr/bin/suidperl -wT

=begin comment info
 +-----------------------------------------------------------------------------+
 | Copyright 2003, Guardian Digital Inc.
 | $Id: do_changepass.pl,v 1.1.1.1 2003/01/09 00:59:43 rwm Exp $
 |
 | Ryan W. Maple <ryan@guardiandigital.com>
 +-----------------------------------------------------------------------------+
=end comment info
=cut

  # use perl;
  use Authen::PAM;
  use CGI;
  use strict;
  use vars qw($username $old_pass $new_pass1 $new_pass2 $pamh $pam_state);

  # Subroutine prototypes.
  sub handle_error($@);
  sub pam_conv_func()

  # Make -T happy, become root.
  $ENV{'PATH'}     = '/usr/bin:/usr/sbin:/bin:/sbin';
  $ENV{'BASH_ENV'} = '/etc/bashrc';
  $< = 0;

  # Get inputs.
  my $q = new CGI;
  $username  = $q->param('username');
  $old_pass  = $q->param('old_pass');
  $new_pass1 = $q->param('new_pass1');
  $new_pass2 = $q->param('new_pass2');


  #
  # Input validation.
  #
  if (! $username) {
    handle_error("'$username' is not a valid 'Username'", 0, 1);
  }
  elsif (! getpwnam($username)) {
    handle_error("'$username' is not a valid 'Username'", 0, 1);
  }
  elsif (! $old_pass) {
    handle_error("Please enter an 'Old Password'", 0, 1);
  }
  elsif (! $new_pass1) {
    handle_error("Please enter a 'New Password'", 0, 1);
  }
  elsif (! $new_pass2) {
    handle_error("Please verify your 'New Password'", 0, 1);
  }
  elsif ($new_pass1 ne $new_pass2) {
    handle_error("The two 'New Passwords' do not match.", 0, 1);
  }


  # Initalizize PAM session.
  my $rv;
  $rv = pam_start('passwd', $username, \&pam_conv_func, $pamh);
  $rv = pam_set_item($pamh, PAM_USER, $username);

  # Authenticate user before we let them change their password.
  $pam_state = "AUTHENTICATE";
  $rv = pam_authenticate($pamh, 0);
  if ($rv != 0) { handle_error("Incorrect 'Old Password'.", 0, 1); }

  # Change the password.
  $pam_state = "CHAUTH-AUTHEN";
  $rv = pam_chauthtok($pamh, 0);
  $rv = pam_end($pamh, 0);

  # Exit gracefully.
  handle_error("Password successfully changed.", 1, 0);
  exit 0;

################################################################################
sub pam_conv_func() {
  my @rv = ();

  while (@_) {
    my $code = shift;
    my $msg  = shift;
    my $ans  = undef;

    if ($code == &PAM_PROMPT_ECHO_OFF) {
      if ($pam_state eq "AUTHENTICATE") {
        $pam_state = "CHAUTH-AUTHEN";
        $ans       = $old_pass;
      }

      elsif ($pam_state eq "CHAUTH-AUTHEN") {
        $pam_state = "CHAUTHTOK";
        $ans       = $new_pass1;
      }

      else { $ans = $new_pass1; }
    }
    # else { handle_error("Error: $msg", 0, 1); }

    push @rv, &PAM_SUCCESS;
    push @rv, $ans;
  }

  push @rv, &PAM_SUCCESS;
  return @rv;
}

################################################################################
sub handle_error($@) {
  my $msg   = shift || return undef;
  my $die   = shift;
  my $foo   = shift;

  print "Content-type: text/html\n\n";

  print "<HTML>\n";
  print "  <HEAD>\n";
  print "    <TITLE>Error!</TITLE>\n\n";
  print "    <SCRIPT LANGUAGE=\"JavaScript\">\n";
  print "      alert(\"$msg\");\n";
  ($die)
    ? print "      window.location='/webmail/src/signout.php';\n"
    : print "      history.go(-1);\n";
  print "    </SCRIPT>\n";
  print "  </HEAD>\n";
  print "</HTML>\n";

  exit -1 if ($foo);
}
